;; This example shows the firmware functions used to save
;; a file.
;;
;; in this example, the file is called SCREEN.SCR
;; and is a dump of the screen (from the default location &c000-&ffff)

;; firmware function to open a file for writing
.cas_out_open equ &bc8c
;; firmware function to write an entire file
;; the file will be written with a AMSDOS header
.cas_out_direct equ &bc98
;; firmware function to close a file opened for writing
.cas_out_close equ &bc8f

org &4000

call save_file
ret


.save_file
;; B = length of the filename in characters
ld b,end_filename-filename

;; HL = address of the start of the filename
ld hl,filename

;; DE = address of a 2k buffer
;; 
;; in disc mode: this buffer is not used when CAS IN DIRECT
;; firmware function is used, so it is safe to put it anywhere
;; you want.
ld de,0

;; firmware function to open a file for reading
call cas_out_open

;; firmware function to write the entire file
;; this will automatically generate a AMSDOS header
;; and write it before the the file data.

;; HL = load address
ld hl,&c000
;; DE = length
ld de,&4000
;; BC = execution address
ld bc,&0000
;; A = file type (2 = binary)
ld a,2

;; write file
call cas_out_direct

;; firmware function to close a file opened for writing
call cas_out_close

ret


;; the filename to save
;; disc filenames are a maximum of 12 characters long
;; 8 characters for name, and 3 characters for extension
.filename
defb "SCREEN.SCR"
.end_filename



